/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import io.emmet.eclipse.EclipseEmmetEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EclipseEmmetHelper {
    private static final String FILE_COLON = "file:";
    private static final String FILE_SLASH = "file:/";
    private static final String FILE_SLASH_SLASH = "file://";

    public static IEditorPart getActiveEditor() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return EclipseEmmetHelper.getTextEditor(editor);
    }

    public static IEditorPart getTextEditor(IEditorPart editor) {
        if (editor instanceof MultiPageEditorPart && ((MultiPageEditorPart)editor).getSelectedPage() instanceof IEditorPart) {
            ITextEditor adapter;
            IEditorPart currentPage = (IEditorPart)((MultiPageEditorPart)editor).getSelectedPage();
            editor = currentPage instanceof ITextEditor ? (ITextEditor)currentPage : ((adapter = (ITextEditor)((MultiPageEditorPart)editor).getAdapter(ITextEditor.class)) != null ? adapter : null);
        }
        return editor;
    }

    public static IDocument getActiveDocument() {
        return EclipseEmmetHelper.getDocument(EclipseEmmetHelper.getActiveEditor());
    }

    public static IDocument getDocument(IEditorPart editor) {
        if (editor != null) {
            IDocumentProvider dp = null;
            if (editor instanceof ITextEditor) {
                dp = ((ITextEditor)editor).getDocumentProvider();
            }
            if (dp == null) {
                dp = DocumentProviderRegistry.getDefault().getDocumentProvider(editor.getEditorInput());
            }
            if (dp != null) {
                return dp.getDocument((Object)editor.getEditorInput());
            }
        }
        return null;
    }

    public static ITextViewer getTextViewer(IEditorPart editor) {
        ITextViewer viewer = null;
        if (editor instanceof AbstractTextEditor) {
            try {
                Field svField = AbstractTextEditor.class.getDeclaredField("fSourceViewer");
                svField.setAccessible(true);
                viewer = (ITextViewer)svField.get((AbstractTextEditor)editor);
            }
            catch (Exception exception) {}
        }
        if (viewer == null) {
            Class<?> editorClass = editor.getClass();
            try {
                Method getViewer = editorClass.getMethod("getViewer", new Class[0]);
                viewer = (ITextViewer)getViewer.invoke((Object)editor, new Object[0]);
            }
            catch (Exception exception) {}
        }
        return viewer;
    }

    public static String getStringOfIFileLocation(IFile file) {
        String location = null;
        IPath path = EclipseEmmetHelper.getPathOfIFileLocation(file);
        if (path != null) {
            location = path.makeAbsolute().toOSString();
        }
        return location;
    }

    public static IPath getPathOfIFileLocation(IFile file) {
        IPath location = null;
        if (file != null && file.exists() && file.getProject() != null && file.getProject().exists()) {
            location = file.getLocation();
        }
        return location;
    }

    public static String getPathFromEditorInput(IEditorInput input) {
        try {
            if (input instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)input).getFile();
                return EclipseEmmetHelper.getStringOfIFileLocation(file);
            }
            if (input instanceof IStorageEditorInput) {
                IStorageEditorInput sei = (IStorageEditorInput)input;
                try {
                    return sei.getStorage().getFullPath().toOSString();
                }
                catch (Exception exception) {
                    if (input instanceof IPathEditorInput) {
                        IPathEditorInput pin = (IPathEditorInput)input;
                        return pin.getPath().toOSString();
                    }
                }
            } else if (input instanceof IPathEditorInput) {
                IPathEditorInput pin = (IPathEditorInput)input;
                return pin.getPath().toOSString();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static String getURI(IEditorPart editor) {
        if (editor != null && editor.getEditorInput() != null) {
            return EclipseEmmetHelper.getURI(editor.getEditorInput());
        }
        return null;
    }

    public static String getURI(IEditorInput input) {
        String s = EclipseEmmetHelper.getPathFromEditorInput(input);
        if (s == null) {
            try {
                Method method = input.getClass().getMethod("getURI", new Class[0]);
                return ((URI)method.invoke((Object)input, new Object[0])).toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return EclipseEmmetHelper.getURI(new File(s));
    }

    public static String getURI(File file) {
        return EclipseEmmetHelper.getURI(file, true);
    }

    public static String getURI(File file, boolean urlEncode) {
        String filePath = null;
        String path = file.getPath();
        if (path.startsWith("file:\\")) {
            filePath = path.replaceAll("file:\\\\", FILE_SLASH_SLASH);
        } else if (path.startsWith("http:\\")) {
            filePath = path.replaceAll("http:\\\\", "http://");
        } else {
            try {
                filePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                filePath = file.getAbsolutePath();
            }
            if (filePath.startsWith("\\\\")) {
                filePath = filePath.substring(2);
            }
            filePath = EclipseEmmetHelper.appendProtocol(filePath);
        }
        filePath = filePath.replaceAll("\\\\", "/");
        if (urlEncode) {
            filePath = EclipseEmmetHelper.urlEncodeFilename(filePath.toCharArray());
        }
        try {
            if (urlEncode) {
                URI uri = new URI(filePath).normalize();
                return uri.toString();
            }
            return filePath;
        }
        catch (URISyntaxException uRISyntaxException) {
            return filePath;
        }
    }

    public static String appendProtocol(String path) {
        if (path.indexOf("://") < 0) {
            return FILE_SLASH_SLASH + path;
        }
        return path;
    }

    public static String urlEncodeFilename(char[] input) {
        if (input == null) {
            return null;
        }
        StringBuffer retu = new StringBuffer(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else if (input[i] == '[') {
                retu.append("%5B");
            } else if (input[i] == ']') {
                retu.append("%5D");
            } else if (input[i] == '{') {
                retu.append("%7B");
            } else if (input[i] == '}') {
                retu.append("%7D");
            } else if (input[i] == '`') {
                retu.append("%60");
            } else if (input[i] == '+') {
                retu.append("%2B");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    public static String getEditorString(EclipseEmmetEditor editor) {
        return editor.getEditor().toString().toLowerCase();
    }

    public static boolean isApatana(EclipseEmmetEditor editor) {
        return EclipseEmmetHelper.getEditorString(editor).indexOf(".aptana.") != -1;
    }
}

