/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import io.emmet.Emmet;
import io.emmet.eclipse.AutoCompleteDialog;
import io.emmet.eclipse.EclipseEmmetEditor;
import io.emmet.eclipse.handlers.ActionRunner;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WrapWithAbbreviationDialog
extends AutoCompleteDialog {
    private Text wrapPreview;
    private static int timerDelay = 200;
    private String previewPlaceholder = "Enter abbreviation to get live preview";
    private String errorPlaceholder = "Invalid abbreviation";

    public WrapWithAbbreviationDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        super(parentShell, dialogTitle, dialogMessage, initialValue);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.wrapPreview = new Text(composite, 2826);
        GridData wrapData = new GridData(1808);
        wrapData.heightHint = this.convertHeightInCharsToPixels(12);
        this.wrapPreview.setLayoutData((Object)wrapData);
        this.setupUpdateListener(composite);
        WrapWithAbbreviationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void setupUpdateListener(final Composite composite) {
        final Color defaultColor = this.wrapPreview.getForeground();
        final Color disabledColor = composite.getDisplay().getSystemColor(15);
        final Color errorColor = composite.getDisplay().getSystemColor(3);
        final Text text = this.getText();
        final Runnable task = new Runnable(){

            @Override
            public void run() {
                String curText = text.getText();
                if (curText.equals("")) {
                    WrapWithAbbreviationDialog.this.wrapPreview.setForeground(disabledColor);
                    WrapWithAbbreviationDialog.this.wrapPreview.setText(WrapWithAbbreviationDialog.this.previewPlaceholder);
                } else {
                    EclipseEmmetEditor editor = ActionRunner.getSingleton().getEditor();
                    String result = Emmet.getSingleton().getWrapPreview(editor, curText);
                    if (result == null || result.equals("") || result.equals("null")) {
                        WrapWithAbbreviationDialog.this.wrapPreview.setForeground(errorColor);
                        WrapWithAbbreviationDialog.this.wrapPreview.setText(WrapWithAbbreviationDialog.this.errorPlaceholder);
                    } else {
                        WrapWithAbbreviationDialog.this.wrapPreview.setForeground(defaultColor);
                        WrapWithAbbreviationDialog.this.wrapPreview.setText(editor.cleanText(result));
                    }
                }
            }
        };
        Listener listener = new Listener(){
            private String lastText = "";
            private Timer timer;

            public void handleEvent(Event e) {
                String curText = text.getText();
                if (!curText.equals(this.lastText)) {
                    if (this.timer != null) {
                        this.timer.cancel();
                    }
                    this.timer = new Timer();
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            composite.getDisplay().syncExec(task);
                        }
                    }, timerDelay);
                    this.lastText = curText;
                }
            }
        };
        text.addListener(2, listener);
        task.run();
    }
}

